#include "SVMInOut.hpp"
int UserInterface(int argc,
		  char *argv[],
		  string &CavFile,
		  string &RefListNme,
		  string &FileListNme,
		  string &OutName,
		  bool &BitVector,
		  svm_parameter &param){
/*****************************************************************/
/* User interface                                                */
/* G. Marcou                                                     */
/*****************************************************************/
    bool ArLoD;//Localized or delocalized Hbond and aromatic interaction
    double HbndLngth,HbndAngle,HbndDngle;//Hbond parameters
    double FFLngth,FFAngle,FFDngle;//Face to Face parameters
    double EFLngth,EFAngle,EFDngle;//Edge to Face parameters
    double HyLngth,IoLngth;//Hydrophobic and ionic interaction length
//
    options_description generic("Allowed options");
//
    string sweight;
    int nfold;
//
//Command definitions
    string SHbndLngth="Hbond length (Angstrom) [Default="+
	dbl2str(HBDISTA,2,5)+"]";
    string SHbndAngle="Hbond angle (rad) [Default="+
	dbl2str(HBANGLE,2,5)+"]";
    string SHbndDngle="Hbond angle tolerance (rad) ([Default="+
	dbl2str(HBDNGLE,2,5)+"]";
    string SFFLngth="Aromatic face to face interaction length (Angstrom) [Default="+
	dbl2str(FFDISTA,2,5)+"]";
    string SFFAngle="Aromatic face to face interaction angle (rad) [Default="+
	dbl2str(FFANGLE,2,5)+"]";
    string SFFDngle="Aromatic face to face interaction angle tolerance (rad) ([Default="+
	dbl2str(FFDNGLE,2,5)+"]";
    string SEFLngth="Aromatic edge to face interaction length (Angstrom) [Default="+
	dbl2str(EFDISTA,2,5)+"]";
    string SEFAngle="Aromatic edge to face interaction angle (rad) [Default="+
	dbl2str(EFANGLE,2,5)+"]";
    string SEFDngle="Aromatic edge to face interaction angle tolerance (rad)[Default="+
	dbl2str(EFDNGLE,2,5)+"]";
    string SHyLngth="Hydrophobic interaction length (Angstrom) [Default="+
	dbl2str(HYDIST,2,5)+"]";
    string SIoLngth="Ionic interaction length (Angstrom) [Default="+
	dbl2str(IONDST,2,5)+"]";
    generic.add_options()
	("help,h", "produce help message")
	("Cavity,C", po::value<string>(&CavFile),"Cavity file name")
	("RefList,R", po::value<string>(&RefListNme),
	 "List of references file name (one per line)")
	("Liglist,L", po::value<string>(&FileListNme),
	 "List of ligand file name (one per line)")
	("Outname,O", po::value<string>(&OutName)->default_value("Out.tan"),
	 "Output file/tree name [Default=Out.tan]")
	("BitVector,B", "References are bitvectors [Default=false]")
	("svm_type,s", po::value<int>(&param.svm_type)->default_value(0),
	 "set type of SVM [Default 0]")
	("kernel_type,t", po::value<int>(&param.kernel_type)->default_value(2),
	 "set type of kernel function [Default 2]")
	("degree,d", po::value<int>(&param.degree)->default_value(3),
	 "set degree in kernel function [Default 3]")
	("gamma,g", po::value<double>(&param.gamma)->default_value(1.0),
	 "set gamma in kernel function [Default 1.0]")
	("coef0,r", po::value<double>(&param.coef0)->default_value(0.0),
	 "set coef0 in kernel function [Default 0.0]")
	("cost,c", po::value<double>(&param.C)->default_value(1.0),
	 "set the parameter C of C-SVC, epsilon-SVR, and nu-SVR [Default 1.0]")
	("nu,n", po::value<double>(&param.nu)->default_value(0.5),
	 "nu : set the parameter nu of nu-SVC, one-class SVM, and nu-SVR [Default 0.5]")
	("svr_epsilon,p", po::value<double>(&param.p)->default_value(0.1),
	 "set the epsilon in loss function of epsilon-SVR [Default 0.1]")
	("cachesize,m", po::value<double>(&param.cache_size)->default_value(100.0),
	 "set cache memory size in MB [Default 100.0]")
	("epsilon,e", po::value<double>(&param.eps)->default_value(0.001),
	 "set tolerance of termination criterion [Default 0.001]")
	("shrinking", po::value<int>(&param.shrinking)->default_value(1),
	 "whether to use the shrinking heuristics, 0 or 1 [Default 1]")
	("probability_estimates", po::value<int>(&param.probability)->default_value(1),
	 "whether to train a SVC or SVR model for probability estimates, 0 or 1 [Default 0]")
	("weight,w", po::value<string>(&sweight)->default_value("1"),
	 "set the parameter C of class i to weight*C, for C-SVC [Default 1]")
	("n_fold,v", po::value<int>(&nfold)->default_value(0),
	 "n-fold cross validation mode [Default 0]")
	("LAro,A", "Ring centere aromatic interaction [Default=false]")
	("HbndLngth", po::value<double>(&HbndLngth)->default_value(HBDISTA),
	 SHbndLngth.c_str())
	("HbndAngle", po::value<double>(&HbndAngle)->default_value(HBANGLE),
	 SHbndAngle.c_str())
	("HbndDngle", po::value<double>(&HbndDngle)->default_value(HBDNGLE),
	 SHbndDngle.c_str())
	("FFLngth", po::value<double>(&FFLngth)->default_value(FFDISTA),
	 SFFLngth.c_str())
	("FFAngle", po::value<double>(&FFAngle)->default_value(FFANGLE),
	 SFFAngle.c_str())
	("FFDngle", po::value<double>(&FFDngle)->default_value(FFDNGLE),
	 SFFDngle.c_str())
	("EFLngth", po::value<double>(&EFLngth)->default_value(EFDISTA),
	 SEFLngth.c_str())
	("EFAngle", po::value<double>(&EFAngle)->default_value(EFANGLE),
	 SEFAngle.c_str())
	("EFDngle", po::value<double>(&EFDngle)->default_value(EFDNGLE),
	 SEFDngle.c_str())
	("HyLngth", po::value<double>(&HyLngth)->default_value(HYDIST),
	 SHyLngth.c_str())
	("IoLngth", po::value<double>(&IoLngth)->default_value(IONDST),
	 SIoLngth.c_str())
	;
//    
    positional_options_description p;
    p.add("CommandFile", -1);
//
//Command parsing
    variables_map vm;
    try{
        store(command_line_parser(argc, argv).
              options(generic).positional(p).run(), vm);
	ifstream ifs("IFP.cmd");
	store(parse_config_file(ifs, generic), vm);
	notify(vm);
    }catch(exception& e){
	cout << generic << endl;
	cout << endl;
	cout << e.what() << endl;
	return 1;
    };
//
//Test for help
    if (vm.count("help")) {
	cout << generic << "\n";
	return 1;
    };
//
//Test for necessary options
    if((FileListNme=="")||(CavFile=="")||(RefListNme=="")){
	cout << generic << endl;
	return 1;
    };
//
// Verbosity
    cout << "Options of your run:" << endl;    
    try{
	cout << "Cavity: " << CavFile << endl;
	cout << "Reference ligands list: " << RefListNme << endl;
	cout << "Ligand list: " << FileListNme << endl;
	cout << "Output file/tree name: " << OutName << endl;
	cout << "Type of SVM: " << param.svm_type << endl;
	cout << "Type of kernel function: " << param.kernel_type << endl;
	cout << "Degree in kernel function: " << param.degree << endl;
	cout << "Gamma in kernel function: " << param.gamma << endl;
	cout << "Coef0 in kernel function: " << param.coef0 << endl;
	cout << "Parameter C of C-SVC, epsilon-SVR, and nu-SVR: " << param.C << endl;
	cout << "Parameter nu of nu-SVC, one-class SVM, and nu-SVR: " << param.nu << endl;
	cout << "Epsilon in loss function of epsilon-SVR: " << param.p << endl; 
	cout << "Cache memory size in MB: " << param.cache_size << endl;
	cout << "Tolerance of termination criterion: " << param.eps << endl;
	cout << "Shrinking heuristics: " << param.shrinking << endl;
	cout << "Train a SVC or SVR model for probability estimates: " << param.probability << endl;
	cout << "Parameter C of class i to weight*C, for C-SVC: " << sweight << endl;
	cout << "Hbond interaction length: " << HbndLngth << " Angstrom" << endl;
	AFP::SetHdist(HbndLngth);
	cout << "Hbond interaction angle: " << HbndAngle << " rad" << endl;
	AFP::SetHangl(HbndAngle);
	cout << "Hbond interaction angle tolerance: " << HbndDngle << " rad" << endl;
	AFP::SetHdngl(HbndDngle);
	cout << "Aromatic face to face inter. length: " << FFLngth << " Angstrom" << endl;
	AFP::SetPSdist(FFLngth);
	cout << "Aromatic face to face inter. angle: " << FFAngle << " rad" << endl;
	AFP::SetPSangl(FFAngle);
	cout << "Aromatic face to face inter. angle tolerance: " << FFDngle << " rad" << endl;
	AFP::SetPSdngl(FFDngle);
	cout << "Aromatic edge to face inter. length: " << EFLngth << " Angstrom" << endl;
	AFP::SetEFdist(EFLngth);
	cout << "Aromatic edge to face inter. angle: " << EFAngle << " rad" << endl;
	AFP::SetEFangl(EFAngle);
	cout << "Aromatic edge to face inter. angle tolerance: " << EFDngle << " rad" << endl;
	AFP::SetEFdngl(EFDngle);
	cout << "Hydrophobic interaction angle: " << HyLngth << " Angstrom" << endl;
	AFP::SetHydist(HyLngth);
	cout << "Ionic interaction length: " << IoLngth << " Angstrom" << endl;
	AFP::SetIondst(IoLngth);
    }catch(exception& e){
	cout << generic << endl;
	cout << endl;
	cout << e.what() << endl;
	return 1;
    };
//Check for n-fold cross validation
    try{
	if(nfold==1){
	    cout << generic << endl;
	    cout << endl;
	    cout << "n-fold cross validation: n must >= 2" << endl;
	    return 1;
	} else {
	    cout << "n-fold cross validation: " << nfold << endl;
	};
    }catch(exception& e){
	cout << generic << endl;
	cout << endl;
	cout << e.what() << endl;
	return 1;
    };
//Catch for weights
    try{
	param.nr_weight = 0;
	param.weight_label = NULL;
	param.weight = NULL;
	if(sweight!="1"){
	    istringstream Snum;
	    Snum.str(sweight);
	    while(Snum){
		++param.nr_weight;
		param.weight_label = (int *)realloc(param.weight_label,sizeof(int)*param.nr_weight);
		param.weight = (double *)realloc(param.weight,sizeof(double)*param.nr_weight);
		Snum >> param.weight_label[param.nr_weight-1];
		Snum >> param.weight[param.nr_weight-1];
	    };
	};
    }catch(exception& e){
	cout << generic << endl;
	cout << endl;
	cout << e.what() << endl;
	return 1;
    };
//
    try{
	if(vm.count("LAro")){
	    ArLoD=true;
	    cout << "Local aromatic interaction description" << endl;
	} else {
	    ArLoD=false;
	    cout << "Unlocal aromatic interaction description" << endl;
	};
	AFP::SetLcloRng(ArLoD);
    }catch(exception& e){
	cout << generic << endl;
	cout << endl;
	cout << e.what() << endl;
	return 1;
    };
//
    try{
	if(vm.count("BitVector")){
	    BitVector=true;
	    cout << "Bit vector references file: ON" << endl;
	} else {
	    BitVector=false;
	    cout << "Bit vector references file: OFF" << endl;
	};
    }catch(exception& e){
	cout << generic << endl;
	cout << endl;
	cout << e.what() << endl;
	return 1;
    };
    return 0;
};
