#ifndef MYAFP_HPP
#define MYAFP_HPP
#include "AFP.hpp"
using namespace OEChem;
using namespace OEMath;
using namespace OESystem;
using namespace std;

class MyAFP:public AFP{
/****************************************************/
/* My Atomic Finger Print.                          */
/* G. Marcou                                        */
/****************************************************/
public:
    MyAFP();
    static inline void SetSmartDist(double d){
	MyAFP::SmartDist=d;
	return;
    };
    static inline bool SetSmartA(string& SSmart){
	bool b;
	MyAFP::SmartA.Clear();
	b=OEParseSmarts(MyAFP::SmartA,SSmart.c_str());
	SSA.Init(SmartA);
	return(b);
    };
    static inline bool SetSmartB(string& SSmart){
	bool b;
	MyAFP::SmartB.Clear();
	b=OEParseSmarts(MyAFP::SmartB,SSmart.c_str());
	SSB.Init(SmartB);
	return(b);
    };
    inline void SetIsSmartA(bool b){
	IsSmartA=b;
	return;
    };
    void SetIsSmartA(OEMolBase&, OEAtomBase*);
    inline void SetIsSmartB(bool b){
	IsSmartB=b;
	return;
    };
    void SetIsSmartB(OEMolBase&, OEAtomBase* X);
    static inline double GetSmartDist(){
	return(MyAFP::SmartDist);
    };
    inline bool GetIsSmartA(){
	return(MyAFP::IsSmartA);
    };
    inline bool GetIsSmartB(){
	return(MyAFP::IsSmartB);
    };
    inline void GetSmartCG(double CG[3]){
	for(int i=0;i<3;++i) CG[i]=MyAFP::SmartCG[i];
	return;
    };
    void SetProperties(OEMolBase&, OEAtomBase*);//Set all properties
    void PropReset();//Reset properties
    void SetDirections(OEMolBase&, OEAtomBase*);
    static inline unsigned int GetBitNbre(){
	unsigned int cpt;
	cpt=AFP::GetBitNbre();
	if(MyAFP::GetSmartDist()>0)
	    cpt++;
	return(cpt);
    };
    friend int operator + (const MyAFP&, const MyAFP&);
private:
    static OEQMol SmartA,SmartB;
    static OESubSearch SSA,SSB;
    bool IsSmartA,IsSmartB;
    static double SmartDist;
    double SmartCG[3];
//     void FindSmartCG(OEMolBase&,OEAtomBase*);
    inline void FindSmartCG(OEMolBase& mol, OEAtomBase* X){
	if((!IsSmartA)&&(!IsSmartB)) return;
	mol.GetCoords(X,MyAFP::SmartCG);
	return;
    };
};
#endif
