#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <vector>
#include <map>
#include "oechem.h"
#include "oesystem.h"
#include "AFP.hpp"
#include "MFP.hpp"
#include "SmlstRng.hpp"
#include "IFPInOut.hpp"
#include "treemedoid.hpp"
#include "Cluster2TreeView.hpp"
extern "C"{
#include "cluster.h"
}
using namespace OEChem;
using namespace OEMath;
using namespace OESystem;
using namespace std;

int main(int argc, char *argv[]){
//
    OEMol lig,cav;
    OEIter<OEAtomBase> ligat,cavat;
    oemolistream ims;
//
    vector<OEBitVector> MMFP;
    vector<OEBitVector>::iterator _MMFP;
    string BVstring,allBV;
//
    int nele,nrows,ncolmn;
    double** p_CTanimo;
    vector<double> Tanimo;
    vector<double>::iterator _Tanimo;
    vector< vector<double> > MTanimo;
    vector< vector<double> >::iterator _MTanimo;
    vector<string> ListEle;
//
// User interface
    string CavFile,FileListNme,LigFile,OutName;
    char ClustMeth;//Clustering method
    bool BitVector;
//
    string RefNme, s_BV;
    istringstream is_BV;
//
    welcome();
//
    int err;
    err=0;
    err=UserInterface(argc,argv,
		      CavFile,FileListNme,OutName,ClustMeth,BitVector);
    if(err) return 1;
//
// Setting the cavity
    ims.SetFormat(OEFormat::MOL2);
    if(!ims.open(CavFile.c_str())){
	cout << "************main Error***********"<< endl;
	cout << "File " << CavFile << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
    ims >> cav;
    ims.close();
//    
    if (OEHasResidues(cav))
    {
	OEPDBOrderAtoms(cav);
    }
    else OEPerceiveResidues(cav);
//
    ifstream FileList(FileListNme.c_str());
    if(!FileList){
	cout << "************main Error***********"<< endl;
	cout << "File " << FileListNme << " does not exists!" << endl;
	cout << "*********************************"<< endl;
	return 1;
    };
//
    MFP CavLig(cav);
//
    nele=0;nrows=0;ncolmn=0;
    if(!BitVector){//ligand
	FileList >> LigFile;
	while(FileList){//process sequencially the ligand files stored
	    cout << "Processing " << LigFile << endl;
	    ims.SetFormat(OEFormat::MOL2);
	    if(!ims.open(LigFile.c_str())){
		cout << "********main loop Warning********"<< endl;
		cout << "Ligand file " << LigFile << " does not exists!" << endl;
		cout << "*********************************"<< endl;
		FileList >> LigFile;
		continue ;
	    };
	    while(ims >> lig){
//
		LigFile=lig.GetTitle();
		cout << "Title: " << LigFile << endl;
		ListEle.push_back(LigFile);
//
		CavLig.ResetIMolFP();
//	CavLig.SetCav(cav);
		CavLig.SetIMolFP(lig);
		MMFP.push_back(CavLig.GetIMolFP());
		allBV.clear();
//
		cout << CavLig << endl;
//Evaluate Tanimoto of this lig. file to all other previously processed
		double d;
		ncolmn=0;
		for(_MMFP=MMFP.begin();_MMFP!=MMFP.end();++_MMFP){
		    d=1.0-OETanimoto(CavLig.GetIMolFP(),*_MMFP);
		    Tanimo.push_back(d);
		    ++nele;++ncolmn;
		};
		++nrows;
		MTanimo.push_back(Tanimo);
		Tanimo.clear();
	    };
	    ims.close();
	    FileList >> LigFile;
	};//All files have been processed
    } else {
	FileList >> RefNme >> s_BV;
	while(FileList){//process sequencially the ligand files stored
	    cout << "Processing " << RefNme << endl;
	    CavLig.ResetIMolFP();
	    is_BV.clear();
	    is_BV.str(s_BV);
	    ListEle.push_back(RefNme);
	    is_BV >> CavLig;
	    MMFP.push_back(CavLig.GetIMolFP());
	    FileList >> RefNme >> s_BV;
//Evaluate Tanimoto of this lig. file to all other previously processed
	    double d;
	    ncolmn=0;
	    for(_MMFP=MMFP.begin();_MMFP!=MMFP.end();++_MMFP){
		d=1.0-OETanimoto(CavLig.GetIMolFP(),*_MMFP);
		Tanimo.push_back(d);
		++nele;++ncolmn;
	    };
	    ++nrows;
	    MTanimo.push_back(Tanimo);
	    Tanimo.clear();
	};
    };//All files have been processed
//
    cout << endl;
    cout << "Distance Matrix" << endl;
    cout << setprecision(3) << fixed << setw(4);
    for(_MTanimo=MTanimo.begin();_MTanimo<MTanimo.end();++_MTanimo){
	Tanimo=*_MTanimo;
 	for(_Tanimo=Tanimo.begin();_Tanimo!=Tanimo.end()-1;++_Tanimo)
	    cout << *_Tanimo << " ";
	cout << endl;
    };
    cout << endl;
//Cluster
    int i;
    p_CTanimo=new double*[nrows];
    p_CTanimo[0]=0;//NULL
    for(i=1;i<nrows;++i)
 	p_CTanimo[i]=new double [i];
    i=0;
    for(_MTanimo=MTanimo.begin();_MTanimo<MTanimo.end();++_MTanimo){
	Tanimo=*_MTanimo;
	int j; j=0;
 	for(_Tanimo=Tanimo.begin();_Tanimo!=Tanimo.end()-1;++_Tanimo){
	    p_CTanimo[i][j]=*_Tanimo;
	    ++j;
	};++i;
    };
//
    int npass;
    double dist;
    int *clusterid;
    clusterid=new int [nrows];
    int* OldId;
    OldId=new int [nrows];
    npass=1000;
    dist=0;
    for(i=0;i<nrows;++i)
	OldId[i]=i;
    ofstream OutTreeFile;
    Node treenodes[nrows-1];
    Node *_treenodes;
    _treenodes = &treenodes[0];
    _treenodes=new Node [nrows-1];
    if(ClustMeth=='k'){
	treekmedoid(nrows,npass,p_CTanimo,OldId,dist,treenodes);
	NexusTreeOut(nrows,treenodes,OutName,ListEle);
    }else{
	_treenodes=treecluster(nrows,ncolmn,0,0,0,0,'e',ClustMeth,p_CTanimo);
	NexusTreeOut(nrows,_treenodes,OutName,ListEle);
    };
//
/*DEBUG
    for(int node=0;node<nrows-1;node++)
	cout << node+1 << " " << result[node][0] << " " << result[node][1] << endl;
*/
//
    return(1);
};
