#include "IAFPInOut.hpp"
int UserInterface(int argc,
		  char *argv[],
		  string &FileListNme,
		  string &OutName,
		  char &ClustMeth){
/*****************************************************************/
/* User interface                                                */
/* G. Marcou                                                     */
/*****************************************************************/
    bool ArLoD;//Localized or delocalized Hbond and aromatic interaction
    double HbndLngth,HbndAngle,HbndDngle;//Hbond parameters
    double FFLngth,FFAngle,FFDngle;//Face to Face parameters
    double EFLngth,EFAngle,EFDngle;//Edge to Face parameters
    double HyLngth,IoLngth;//Hydrophobic and ionic interaction length
//
    options_description generic("Allowed options");
//
//Command definitions
    string SHbndLngth="Hbond length (Angstrom) [Default="+
	dbl2str(HBDISTA,2,5)+"]";
    string SHbndAngle="Hbond angle (rad) [Default="+
	dbl2str(HBANGLE,2,5)+"]";
    string SHbndDngle="Hbond angle tolerance (rad) ([Default="+
	dbl2str(HBDNGLE,2,5)+"]";
    string SFFLngth="Aromatic face to face interaction length (Angstrom) [Default="+
	dbl2str(FFDISTA,2,5)+"]";
    string SFFAngle="Aromatic face to face interaction angle (rad) [Default="+
	dbl2str(FFANGLE,2,5)+"]";
    string SFFDngle="Aromatic face to face interaction angle tolerance (rad) ([Default="+
	dbl2str(FFDNGLE,2,5)+"]";
    string SEFLngth="Aromatic edge to face interaction length (Angstrom) [Default="+
	dbl2str(EFDISTA,2,5)+"]";
    string SEFAngle="Aromatic edge to face interaction angle (rad) [Default="+
	dbl2str(EFANGLE,2,5)+"]";
    string SEFDngle="Aromatic edge to face interaction angle tolerance (rad)[Default="+
	dbl2str(EFDNGLE,2,5)+"]";
    string SHyLngth="Hydrophobic interaction length (Angstrom) [Default="+
	dbl2str(HYDIST,2,5)+"]";
    string SIoLngth="Ionic interaction length (Angstrom) [Default="+
	dbl2str(IONDST,2,5)+"]";
    generic.add_options()
	("help,h", "produce help message")
	("Liglist,L", po::value<string>(&FileListNme),
	 "List of blank separated ligand cavity file names (one per line)")
	("Outname,O", po::value<string>(&OutName)->default_value("usr.tre"),
	 "Output file/tree name [Default=usr.tre]")
	("ClustMeth,m", po::value<char>(&ClustMeth)->default_value('s'),
	 "Hierarchical clustering method (s|m|a) [Default=s]")
	("LAro,A", "Ring centere aromatic interaction [Default=false]")
	("HbndLngth", po::value<double>(&HbndLngth)->default_value(HBDISTA),
	 SHbndLngth.c_str())
	("HbndAngle", po::value<double>(&HbndAngle)->default_value(HBANGLE),
	 SHbndAngle.c_str())
	("HbndDngle", po::value<double>(&HbndDngle)->default_value(HBDNGLE),
	 SHbndDngle.c_str())
	("FFLngth", po::value<double>(&FFLngth)->default_value(FFDISTA),
	 SFFLngth.c_str())
	("FFAngle", po::value<double>(&FFAngle)->default_value(FFANGLE),
	 SFFAngle.c_str())
	("FFDngle", po::value<double>(&FFDngle)->default_value(FFDNGLE),
	 SFFDngle.c_str())
	("EFLngth", po::value<double>(&EFLngth)->default_value(EFDISTA),
	 SEFLngth.c_str())
	("EFAngle", po::value<double>(&EFAngle)->default_value(EFANGLE),
	 SEFAngle.c_str())
	("EFDngle", po::value<double>(&EFDngle)->default_value(EFDNGLE),
	 SEFDngle.c_str())
	("HyLngth", po::value<double>(&HyLngth)->default_value(HYDIST),
	 SHyLngth.c_str())
	("IoLngth", po::value<double>(&IoLngth)->default_value(IONDST),
	 SIoLngth.c_str())
	;
//    
    positional_options_description p;
    p.add("CommandFile", -1);
//
//Command parsing
    variables_map vm;
    try{
        store(command_line_parser(argc, argv).
              options(generic).positional(p).run(), vm);
	ifstream ifs("IAFP.cmd");
	store(parse_config_file(ifs, generic), vm);
	notify(vm);
    }catch(exception& e){
	cout << generic << endl;
	cout << endl;
	cout << e.what() << endl;
	return 1;
    };
//
//Test for help
    if (vm.count("help")) {
	cout << generic << "\n";
	return 1;
    };
//
//Test for necessary options
    if(FileListNme==""){
	cout << generic << endl;
	return 1;
    };
//
// Verbosity
    cout << "Options of your run:" << endl;    
    try{
	cout << "Ligand Cavity list: " << FileListNme << endl;
	cout << "Output file/tree name: " << OutName << endl;
	cout << "Hierarchical clustering method: " << ClustMeth << endl;
	cout << "Hbond interaction length: " << HbndLngth << " Angstrom" << endl;
	AFP::SetHdist(HbndLngth);
	cout << "Hbond interaction angle: " << HbndAngle << " rad" << endl;
	AFP::SetHangl(HbndAngle);
	cout << "Hbond interaction angle tolerance: " << HbndDngle << " rad" << endl;
	AFP::SetHdngl(HbndDngle);
	cout << "Aromatic face to face inter. length: " << FFLngth << " Angstrom" << endl;
	AFP::SetPSdist(FFLngth);
	cout << "Aromatic face to face inter. angle: " << FFAngle << " rad" << endl;
	AFP::SetPSangl(FFAngle);
	cout << "Aromatic face to face inter. angle tolerance: " << FFDngle << " rad" << endl;
	AFP::SetPSdngl(FFDngle);
	cout << "Aromatic edge to face inter. length: " << EFLngth << " Angstrom" << endl;
	AFP::SetEFdist(EFLngth);
	cout << "Aromatic edge to face inter. angle: " << EFAngle << " rad" << endl;
	AFP::SetEFangl(EFAngle);
	cout << "Aromatic edge to face inter. angle tolerance: " << EFDngle << " rad" << endl;
	AFP::SetEFdngl(EFDngle);
	cout << "Hydrophobic interaction angle: " << HyLngth << " Angstrom" << endl;
	AFP::SetHydist(HyLngth);
	cout << "Ionic interaction length: " << IoLngth << " Angstrom" << endl;
	AFP::SetIondst(IoLngth);
    }catch(exception& e){
	cout << generic << endl;
	cout << endl;
	cout << e.what() << endl;
	return 1;
    };
//
    try{
	if(vm.count("LAro")){
	    ArLoD=true;
	    cout << "Local aromatic interaction description" << endl;
	} else {
	    ArLoD=false;
	    cout << "Unlocal aromatic interaction description" << endl;
	};
	AFP::SetLcloRng(ArLoD);
    }catch(exception& e){
	cout << generic << endl;
	cout << endl;
	cout << e.what() << endl;
	return 1;
    };
    return 0;
}
// /*****************************************************************/
// void NexusTreeOut(int nrows, int result[][2],
// 		  double linkdist[],string OutName, vector<string> ListEle){
// /*****************************************************************/
// /* Nexus tree format output for C cluster library hirarchical    */
// /* clusturing output. Output on OutName.                         */
// /* G. Marcou                                                     */
// /*****************************************************************/
// //
//     int i,j;
//     string tree;//tree string
//     vector<string> vtree;//node tree string
//     bool *_vis,*_finished;//is a node already visited or finished?
//     _vis=new bool [nrows-1];
//     _finished=new bool [nrows-1];
//     list<int> path;//trail in the tree
// //
// //initialization
//     for(i=0;i<nrows-1;++i){
// 	_vis[i]=false;
// 	_finished[i]=false;
//     };
// //
//     i=0;//node index
//     while(i<(nrows-1)){
// 	if(!_vis[i]){//this node was never visited 
// 	    _vis[i]=true;
// 	    j=0;//the leftmost branch
// 	    tree+="(";
// 	    if(result[i][j]>=0){//This is a leaf
// 		tree+=int2str(result[i][j]+1);
// 		tree+=":"+dbl2str(linkdist[i]*100,3,4);
// 	    }else{//follow the branch
// 		if(!_finished[-result[i][j]-1]){
// 		    path.push_back(i);
// 		    i=-result[i][j]-1;
// 		}else{//if the branch was already parsed add the output
// 		    tree+=vtree.at(-result[i][j]-1);
// 		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
// 		};
// 		continue;
// 	    };
// 	} else {//This node was already visited
// 	    j=1;//The tree is binary. This is the rightmost branch 
// 	    if(!_finished[i]){//if it was not finished
// 		tree+=",";
// 		_finished[i]=true;
// 		if(result[i][j]>=0){//This is a leaf
// 		    tree+=int2str(result[i][j]+1);
// 		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
// 		}else{//follow the path
// 		    if(!_finished[-result[i][j]-1]){
// 			path.push_back(i);
// 			i=-result[i][j]-1;
// 		    }else{//if the next node was already parsed add it
// 			tree+=vtree.at(-result[i][j]-1);
// 			tree+=":"+dbl2str(linkdist[i]*100,3,4);
// 		    };
// 		};
// 		continue;
// 	    };
// 	    if(_finished[i]){//if the current node was finished
// 		if(!tree.empty()){//nothing to add
// 		    tree+=")";
// 		};
// 		if(path.empty()){//nothing to go back to
// 		    if(!tree.empty()){
// 			vtree.push_back(tree);
// 			tree.clear();
// 		    };
// 		    i++;//go to the next node
// 		}else{//go back to the parent node
// 		    i=path.back();
// 		    path.pop_back();
// 		};
// 	    };
// 	};
//     };
//     tree=vtree.back();
//     tree+=";";
// //Nexus format litterature
//     ofstream OutTreeFile;
//     OutTreeFile.open(OutName.c_str());
//     OutTreeFile << "#NEXUS" << endl;
//     OutTreeFile << "BEGIN TREES;" << endl;
//     OutTreeFile << "[!]" << endl;
//     OutTreeFile << "\t TRANSLATE" << endl;
//     for(i=0;i<nrows-1;++i)
// 	OutTreeFile << "\t \t " << i+1 << "\t" << ListEle[i] << "," << endl;
//     OutTreeFile << "\t \t " << i+1 << "\t" << ListEle[i] << endl;
//     OutTreeFile << "\t \t ;" << endl;
//     OutTreeFile << "\t TREE " << OutName << " = ";
//     OutTreeFile << tree << endl;
//     OutTreeFile << "ENDBLOCK;" << endl;
//     OutTreeFile.close();
// //
//     return;
// };
// /*****************************************************************/
// void NexusTreeOut(int nrows, int result[][2],
// 		  double linkdist[],vector<string> ListEle){
// /*****************************************************************/
// /* Nexus tree format output for C cluster library hirarchical    */
// /* clusturing output. Output on stdout.                          */
// /* G. Marcou                                                     */
// /*****************************************************************/
// //
//     int i,j;
//     string tree;//tree string
//     vector<string> vtree;//node tree string
//     bool *_vis,*_finished;//is a node already visited or finished?
//     _vis=new bool [nrows-1];
//     _finished=new bool [nrows-1];
//     list<int> path;//trail in the tree
// //
// //initialization
//     for(i=0;i<nrows-1;++i){
// 	_vis[i]=false;
// 	_finished[i]=false;
//     };
// //
//     i=0;//node index
//     while(i<(nrows-1)){
// 	if(!_vis[i]){//this node was never visited 
// 	    _vis[i]=true;
// 	    j=0;//the leftmost branch
// 	    tree+="(";
// 	    if(result[i][j]>=0){//This is a leaf
// 		tree+=int2str(result[i][j]+1);
// 		tree+=":"+dbl2str(linkdist[i]*100,3,4);
// 	    }else{//follow the branch
// 		if(!_finished[-result[i][j]-1]){
// 		    path.push_back(i);
// 		    i=-result[i][j]-1;
// 		}else{//if the branch was already parsed add the output
// 		    tree+=vtree.at(-result[i][j]-1);
// 		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
// 		};
// 		continue;
// 	    };
// 	} else {//This node was already visited
// 	    j=1;//The tree is binary. This is the rightmost branch 
// 	    if(!_finished[i]){//if it was not finished
// 		tree+=",";
// 		_finished[i]=true;
// 		if(result[i][j]>=0){//This is a leaf
// 		    tree+=int2str(result[i][j]+1);
// 		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
// 		}else{//follow the path
// 		    if(!_finished[-result[i][j]-1]){
// 			path.push_back(i);
// 			i=-result[i][j]-1;
// 		    }else{//if the next node was already parsed add it
// 			tree+=vtree.at(-result[i][j]-1);
// 			tree+=":"+dbl2str(linkdist[i]*100,3,4);
// 		    };
// 		};
// 		continue;
// 	    };
// 	    if(_finished[i]){//if the current node was finished
// 		if(!tree.empty()){//nothing to add
// 		    tree+=")";
// 		};
// 		if(path.empty()){//nothing to go back to
// 		    if(!tree.empty()){
// 			vtree.push_back(tree);
// 			tree.clear();
// 		    };
// 		    i++;//go to the next node
// 		}else{//go back to the parent node
// 		    i=path.back();
// 		    path.pop_back();
// 		};
// 	    };
// 	};
//     };
//     tree=vtree.back();
//     tree+=";";
// //Nexus format litterature
//     cout << "#NEXUS" << endl;
//     cout << "BEGIN TREES;" << endl;
//     cout << "[!]" << endl;
//     cout << "\t TRANSLATE" << endl;
//     for(i=0;i<nrows-1;++i)
// 	cout << "\t \t " << i+1 << "\t" << ListEle[i] << "," << endl;
//     cout << "\t \t " << i+1 << "\t" << ListEle[i] << endl;
//     cout << "\t \t ;" << endl;
//     cout << "\t TREE USER = ";
//     cout << tree << endl;
//     cout << "ENDBLOCK;" << endl;
// //
//     return;
// };
