#include "ExtAFP.hpp"
double ExtAFP::WHBdist=WHBDISTA;
double ExtAFP::WHBangle=WHBANGLE;
double ExtAFP::WHBdngle=WHBDNGLE;
double ExtAFP::PiCatdist=PICATDISTA;
double ExtAFP::PiCatangle=PICATANGLE;
double ExtAFP::PiCatdngle=PICATDNGLE;
double ExtAFP::Metaldist=METALDIST;
/****************************************************/
ExtAFP::ExtAFP(){
//
    AFP::SetTopPrime(32);
    AFP::SetPrimNbre();
//
    ExtAFP::IsWHBA=false;
    ExtAFP::IsWHBD=false;
    ExtAFP::IsMetal=false;
//
    for(int i=0;i<3;++i){
	ExtAFP::WGC[i]=0;
	ExtAFP::WHdir[i]=0;
	ExtAFP::PiCatGC[i]=0;
	ExtAFP::PiCatdir[i]=0;
	ExtAFP::MetalGC[i]=0;
    };
}
/****************************************************/
// void ExtAFP::SetIsHA(OEAtomBase *X){//Is an H-bond acceptor
// /************************************************************/
// /* Extension of H-bond acceptor definition.                 */
// /* G. Marcou                                                */
// /************************************************************/
//     AFP::SetIsHA(X);
//     int typ=X->GetAtomicNum();
//     if((typ==17)||(typ==9)){//Cl=17, F=9
// 	    AFP::SetIsHA(true);
//     };
//     return;
// };
// void ExtAFP::SetIsHy(OEAtomBase *X){//Is Hydrophobe
// /************************************************************/
// /* An hydrophobic atom is an hydrogen covalently linked to  */
// /* a carbon or carbon alone.                                */
// /* G. Marcou                                                */
// /************************************************************/
//     AFP::SetIsHy(X);
//     int typ=X->GetAtomicNum();
//     if((typ==35)||(typ==53)){//Br=35, I=53
// 	AFP::SetIsHy(true);
//     };
//     return;
// };
// /************************************************************/
void ExtAFP::SetIsMetal(OEAtomBase *X){
/************************************************************/
/* A metal is either a Mg, Ca, Mn, Fe, Co, Ni, Zn, Cu or Cd */
/* G. Marcou                                                */
/************************************************************/
    int typ=X->GetAtomicNum();
    ExtAFP::IsMetal=false;
    if((typ==12)||(typ==20)||(typ==25)||(typ==26)||(typ==27)||
       (typ==28)||(typ==29)||(typ==30)||(typ==48)){
//Mg=12, Ca=20, Mn=25, Fe=26, Co=27, Ni=28, Cu=29, Zn=30, Cd=48
	    ExtAFP::IsMetal=true;
    };
    return;
};
/****************************************************/
void ExtAFP::SetIsWHBA(OEAtomBase* X){
/************************************************************/
/* A weak H-bond acceptor is either a neutral sulfur or     */
/* pi-electronic cloud (carbon sp, sp2 or aromatic).        */
/* G. Marcou                                                */
/************************************************************/
    ExtAFP::IsWHBA=false;
    if(X->IsAromatic()){
	ExtAFP::IsWHBA=true;
    } else if((OEGetHybridization(X)==1)||(OEGetHybridization(X)==2)){
	ExtAFP::IsWHBA=true;
    };
//
    if((X->IsSulfur())&&(X->GetFormalCharge()==0))
	ExtAFP::IsWHBA=true;
    return;
};
/****************************************************/
void ExtAFP::SetIsWHBD(OEAtomBase* X){
/************************************************************/
/* A weak H-bond donor is an hydrogen covalently bond to    */
/* either an sp, sp2 or aromatic carbon.                    */
/* G. Marcou                                                */
/************************************************************/
    ExtAFP::IsWHBD=false;
    if(X->IsHydrogen()){
	OEIter<OEAtomBase> Y=X->GetAtoms();
	if((Y->IsCarbon())&&(Y->IsAromatic())){
	    ExtAFP::IsWHBD=true;
	} else if((Y->IsCarbon())&&(
		      (OEGetHybridization(Y)==1)||(OEGetHybridization(Y)==2))){
	    ExtAFP::IsWHBD=true;
	};
    };
    return;
};
/************************************************************/
void ExtAFP::SetProperties(OEAtomBase *X){
/************************************************************/
/* Set all properties                                       */
/* G. Marcou                                                */
/************************************************************/
    AFP::SetProperties(X);
//
    ExtAFP::SetIsWHBA(X);
    ExtAFP::SetIsWHBD(X);
    ExtAFP::SetIsMetal(X);
    return;
};
/************************************************************/
//Tools
void ExtAFP::PropReset(){
/************************************************************/
/* Reset properties                                         */
/* G. Marcou                                                */
/************************************************************/
    AFP::PropReset();
//
    ExtAFP::IsWHBD=false;
    ExtAFP::IsWHBA=false;
    ExtAFP::IsMetal=false;
//
    for(int i=0;i<3;++i){
	ExtAFP::WGC[i]=0;
	ExtAFP::WHdir[i]=0;
	ExtAFP::PiCatGC[i]=0;
	ExtAFP::PiCatdir[i]=0;
	ExtAFP::MetalGC[i]=0;
    };
 //
    return;
};
/************************************************************/
void ExtAFP::MolGC(OEMolBase& PiCloud, double GC[3]){
/************************************************************/
/* Set GC on the gravity center of the Pi-electronic cloud. */
/* NOTE: This method maybe moved in more relevant classes   */
/* future release of the library.                           */
/* G. Marcou                                                */
/************************************************************/
    OEIter<OEAtomBase> OEA_C;    
    double XYZ_C[3];
    int i,N;
//
//Geometric Center
    N=0;
    for(i=0;i<3;++i)
	GC[i]=0;
    for(OEA_C=PiCloud.GetAtoms();OEA_C;++OEA_C){
	++N;
	PiCloud.GetCoords(OEA_C,XYZ_C);
	for(i=0;i<3;++i)
	    GC[i]+=XYZ_C[i];
    };
    for(i=0;i<3;++i)
	GC[i]=GC[i]/N;
//
    return;
};
/************************************************************/
void ExtAFP::WHDFind(OEMolBase &conf, OEAtomBase *OEA_D, OEAtomBase *OEA_H){
/************************************************************/
/* Find the D-H vector and set GC the interaction center    */
/* G. Marcou                                                */
/************************************************************/
    double XYZ_D[3],XYZ_H[3],U[3];
//
    conf.GetCoords(OEA_D,XYZ_D);
    conf.GetCoords(OEA_H,XYZ_H);
    ExtAFP::SetWGC(XYZ_D);
//
    OEGeom3DSubtract(U,XYZ_H,XYZ_D);
    OEGeom3DNormalize(U);
//
    ExtAFP::SetWHDdir(U);
//
    return;    
};
/************************************************************/
void ExtAFP::SetDirections(OEMolBase &mol, OEAtomBase *X){
/************************************************************/
/* Set directions of aromaticity and H-bonds                */
/* G. Marcou                                                */
/************************************************************/
    AFP::SetDirections(mol,X);
    double GC[3], dir[3];
//
    OEMol PiCloud;
    OEIter<OEAtomBase> near;
    OEIter<OEAtomBase> Y=X->GetAtoms();
    if(ExtAFP::GetIsMetal()) ExtAFP::MetalFind(mol,X);//Metal geometry
    if(AFP::GetIsCat()) ExtAFP::CatFind(mol,X);//Cation geometry
    if(AFP::GetIsAr()){
	SmlstRng SR;
	SR.SetSearch(*X);
	SR.FndARng(X,X->GetIdx());
	SR.CleanRng();
	SR.RngNml(GC,dir);
	PiCloud=SR.GetSmlstRng();
	ExtAFP::SetPiCatGC(GC);//Pi-Cat Geometry
	ExtAFP::SetPiCatdir(dir);
	if(ExtAFP::GetIsWHBA())
	    ExtAFP::SetWGC(GC);//Aromatic WHB Acceptor geometry
    };
    if(ExtAFP::GetIsWHBD()) ExtAFP::WHDFind(mol,Y,X);//WHB Donor geometry
    if((ExtAFP::GetIsWHBA())&&(!AFP::GetIsAr())){
	if((OEGetHybridization(X)==1)||(OEGetHybridization(X)==2)){
	    PiCloud.NewAtom(*X);
	    for(near=X->GetAtoms();near;++near)
		if((OEGetHybridization(near)==1)||
		   (OEGetHybridization(near)==2))
		    PiCloud.NewAtom(*near);
	} else if(X->IsSulfur()){
	    PiCloud.NewAtom(*X);
	} else {
	    cout << "**************ExtAFP::SetDirections***********"<< endl;
	    cout << " ERROR: improper weak hydrogen bond acceptor  "<< endl;
	    cout << "**********************************************"<< endl;
	    cout << "Molecule: " << mol.GetTitle() << endl;
	    cout << "Atom: " << X->GetName() << " " << OEGetResidueName(OEGetResidueIndex(X)) << " " << OEGetResidueIndex(X) << " "<< X->GetIdx() << endl;
	    exit(1);
	};
	ExtAFP::WHAFind(PiCloud);
    };
    return;
};
//Arithmetic
/************************************************************/
int operator + ( const ExtAFP &a, const ExtAFP &b){
/************************************************************/
/* Addition operator: given two Atomic Finger Prints, check */
/* what kind of interactions actually exists.               */
/*       1: No interactions                                 */
/*       2: Hydrophobic                                     */
/*       3: Pi stacking                                     */
/*       5: Edge to face                                    */
/*       7: H-bond Donor Acceptor                           */
/*      11: H-bond Acceptor Donor                           */
/*      13: Ionic interaction + -                           */
/*      17: Ionic interaction - +                           */
/*      19: Weak H-bond Donor Acceptor                      */
/*      23: Weak H-bond Acceptor Donor                      */
/*      29: Pi-Cation                                       */
/*      31: Metal coordination                              */
/* Multiple kind of interactions are given by products:     */
/*    Hydrophobic AND Pi stacking= 3*5                      */
/* G. Marcou                                                */
/************************************************************/
    double U[3],aGC[3],bGC[3],aHD[3],bHD[3],HD[3];
    double scalar;
    int i,Inter;
//
    map<int,int> PrimNbre=AFP::GetPrimNbre();
    map<int,int>::iterator _PrimNbre=PrimNbre.begin();
//
    Inter=AFP(a)+AFP(b);
    for(unsigned int j=0;j<AFP::GetBitNbre();j++)
	_PrimNbre++;
//
    if(a.GetIsMetal())
	a.GetMetalGC(aGC);
    if(b.GetIsMetal())
	b.GetMetalGC(bGC);
//
    if(ExtAFP::GetWHBdist()>0){
	if((a.GetIsWHBD()&&b.GetIsWHBA())|
	   (a.GetIsHD()&&b.GetIsWHBA())|
	   (a.GetIsWHBD()&&b.GetIsHA())){
//
	    a.GetWGC(aGC);
	    a.GetWHDdir(aHD);
	    b.GetWGC(bGC);
	    b.GetWHDdir(bHD);
//
	    OEGeom3DSubtract(U,bGC,aGC);//D-H...A direction
	    OEGeom3DNormalize(U);	
	    scalar=0;
	    for(i=0;i<3;++i) scalar+=aHD[i]*U[i];
//H-bond geometry control
	    if(abs(acos(scalar)-ExtAFP::GetWHBangle())<abs(ExtAFP::GetWHBdngle()))
		if(OEGeom3DDistance(aGC,bGC)<ExtAFP::GetWHBdist())
		    Inter*=_PrimNbre->second;
	};
	_PrimNbre++;
    };
//
    if(ExtAFP::GetWHBdist()>0){
	if((a.GetIsWHBA()&&b.GetIsWHBD())|
	   (a.GetIsHA()&&b.GetIsWHBD())|
	   (a.GetIsWHBA()&&b.GetIsHD())){
//
	    a.GetWGC(aGC);
	    a.GetWHDdir(aHD);
	    b.GetWGC(bGC);
	    b.GetWHDdir(bHD);
//
	    OEGeom3DSubtract(U,aGC,bGC);//D-H...A direction
	    OEGeom3DNormalize(U);	
	    scalar=0;
	    for(i=0;i<3;++i) scalar+=bHD[i]*U[i];
//H-bond geometry control
	    if(abs(acos(scalar)-ExtAFP::GetWHBangle())<abs(ExtAFP::GetWHBdngle()))
		if(OEGeom3DDistance(aGC,bGC)<ExtAFP::GetWHBdist())
		    Inter*=_PrimNbre->second;
	};
	_PrimNbre++;
    };
//
    if(ExtAFP::GetPiCatdist()>0){
	if((a.GetIsCat()&&b.GetIsAr())||(b.GetIsCat()&&a.GetIsAr())){
//
	    a.GetPiCatGC(aGC);
	    if(a.GetIsAr())
		a.GetPiCatdir(HD);
	    b.GetPiCatGC(bGC);
	    if(b.GetIsAr())
		b.GetPiCatdir(HD);
//
	    OEGeom3DSubtract(U,bGC,aGC);//Pi...Cat direction
	    OEGeom3DNormalize(U);	
	    scalar=0;
	    for(i=0;i<3;++i) scalar+=HD[i]*U[i];
//Pi-Cation geometry control
	    if(abs(acos(scalar)-ExtAFP::GetPiCatangle())<
	       abs(ExtAFP::GetPiCatdngle()))
		if(OEGeom3DDistance(aGC,bGC)<ExtAFP::GetPiCatdist())
		    Inter*=_PrimNbre->second;
	};
	_PrimNbre++;
    };
//
    if(ExtAFP::GetMetaldist()>0){
	if((a.GetIsMetal()&&b.GetIsHA())||(b.GetIsMetal()&&a.GetIsHA())){
//
	    if(a.GetIsMetal()&&b.GetIsHA()){
		a.GetMetalGC(aGC);
		b.GetHAGC(bGC);
	    } else {
		b.GetMetalGC(bGC);
		a.GetHAGC(aGC);
	    };
//
	    if(OEGeom3DDistance(aGC,bGC)<ExtAFP::GetMetaldist()){
		Inter*=_PrimNbre->second;
	    };
	};
    };
//
    return(Inter);
};
