#include "Cluster2TreeView.hpp"
/*****************************************************************/
void NexusTreeOut(int nrows, int result[][2],
		  double linkdist[],string OutName, vector<string> ListEle){
/*****************************************************************/
/* Nexus tree format output for C cluster library hirarchical    */
/* clusturing output. Output on OutName.                         */
/* G. Marcou                                                     */
/*****************************************************************/
//
    int i,j;
    string tree;//tree string
    vector<string> vtree;//node tree string
    bool *_vis,*_finished;//is a node already visited or finished?
    _vis=new bool [nrows-1];
    _finished=new bool [nrows-1];
    list<int> path;//trail in the tree
//
//initialization
    for(i=0;i<nrows-1;++i){
	_vis[i]=false;
	_finished[i]=false;
    };
//
    i=0;//node index
    while(i<(nrows-1)){
	if(!_vis[i]){//this node was never visited 
	    _vis[i]=true;
	    j=0;//the leftmost branch
	    tree+="(";
	    if(result[i][j]>=0){//This is a leaf
		tree+=int2str(result[i][j]+1);
		tree+=":"+dbl2str(linkdist[i]*100,3,4);
	    }else{//follow the branch
		if(!_finished[-result[i][j]-1]){
		    path.push_back(i);
		    i=-result[i][j]-1;
		}else{//if the branch was already parsed add the output
		    tree+=vtree.at(-result[i][j]-1);
		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
		};
		continue;
	    };
	} else {//This node was already visited
	    j=1;//The tree is binary. This is the rightmost branch 
	    if(!_finished[i]){//if it was not finished
		tree+=",";
		_finished[i]=true;
		if(result[i][j]>=0){//This is a leaf
		    tree+=int2str(result[i][j]+1);
		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
		}else{//follow the path
		    if(!_finished[-result[i][j]-1]){
			path.push_back(i);
			i=-result[i][j]-1;
		    }else{//if the next node was already parsed add it
			tree+=vtree.at(-result[i][j]-1);
			tree+=":"+dbl2str(linkdist[i]*100,3,4);
		    };
		};
		continue;
	    };
	    if(_finished[i]){//if the current node was finished
		if(!tree.empty()){//nothing to add
		    tree+=")";
		};
		if(path.empty()){//nothing to go back to
		    if(!tree.empty()){
			vtree.push_back(tree);
			tree.clear();
		    };
		    i++;//go to the next node
		}else{//go back to the parent node
		    i=path.back();
		    path.pop_back();
		};
	    };
	};
    };
    tree=vtree.back();
    tree+=";";
//Nexus format litterature
    ofstream OutTreeFile;
    OutTreeFile.open(OutName.c_str());
    OutTreeFile << "#NEXUS" << endl;
    OutTreeFile << "BEGIN TREES;" << endl;
    OutTreeFile << "[!]" << endl;
    OutTreeFile << "\t TRANSLATE" << endl;
    for(i=0;i<nrows-1;++i)
	OutTreeFile << "\t \t " << i+1 << "\t" << ListEle[i] << "," << endl;
    OutTreeFile << "\t \t " << i+1 << "\t" << ListEle[i] << endl;
    OutTreeFile << "\t \t ;" << endl;
    OutTreeFile << "\t TREE " << OutName << " = ";
    OutTreeFile << tree << endl;
    OutTreeFile << "ENDBLOCK;" << endl;
    OutTreeFile.close();
//
    return;
};
/*****************************************************************/
void NexusTreeOut(int nrows, int result[][2],
		  double linkdist[],vector<string> ListEle){
/*****************************************************************/
/* Nexus tree format output for C cluster library hirarchical    */
/* clusturing output. Output on stdout.                          */
/* G. Marcou                                                     */
/*****************************************************************/
//
    int i,j;
    string tree;//tree string
    vector<string> vtree;//node tree string
    bool *_vis,*_finished;//is a node already visited or finished?
    _vis=new bool [nrows-1];
    _finished=new bool [nrows-1];
    list<int> path;//trail in the tree
//
//initialization
    for(i=0;i<nrows-1;++i){
	_vis[i]=false;
	_finished[i]=false;
    };
//
    i=0;//node index
    while(i<(nrows-1)){
	if(!_vis[i]){//this node was never visited 
	    _vis[i]=true;
	    j=0;//the leftmost branch
	    tree+="(";
	    if(result[i][j]>=0){//This is a leaf
		tree+=int2str(result[i][j]+1);
		tree+=":"+dbl2str(linkdist[i]*100,3,4);
	    }else{//follow the branch
		if(!_finished[-result[i][j]-1]){
		    path.push_back(i);
		    i=-result[i][j]-1;
		}else{//if the branch was already parsed add the output
		    tree+=vtree.at(-result[i][j]-1);
		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
		};
		continue;
	    };
	} else {//This node was already visited
	    j=1;//The tree is binary. This is the rightmost branch 
	    if(!_finished[i]){//if it was not finished
		tree+=",";
		_finished[i]=true;
		if(result[i][j]>=0){//This is a leaf
		    tree+=int2str(result[i][j]+1);
		    tree+=":"+dbl2str(linkdist[i]*100,3,4);
		}else{//follow the path
		    if(!_finished[-result[i][j]-1]){
			path.push_back(i);
			i=-result[i][j]-1;
		    }else{//if the next node was already parsed add it
			tree+=vtree.at(-result[i][j]-1);
			tree+=":"+dbl2str(linkdist[i]*100,3,4);
		    };
		};
		continue;
	    };
	    if(_finished[i]){//if the current node was finished
		if(!tree.empty()){//nothing to add
		    tree+=")";
		};
		if(path.empty()){//nothing to go back to
		    if(!tree.empty()){
			vtree.push_back(tree);
			tree.clear();
		    };
		    i++;//go to the next node
		}else{//go back to the parent node
		    i=path.back();
		    path.pop_back();
		};
	    };
	};
    };
    tree=vtree.back();
    tree+=";";
//Nexus format litterature
    cout << "#NEXUS" << endl;
    cout << "BEGIN TREES;" << endl;
    cout << "[!]" << endl;
    cout << "\t TRANSLATE" << endl;
    for(i=0;i<nrows-1;++i)
	cout << "\t \t " << i+1 << "\t" << ListEle[i] << "," << endl;
    cout << "\t \t " << i+1 << "\t" << ListEle[i] << endl;
    cout << "\t \t ;" << endl;
    cout << "\t TREE USER = ";
    cout << tree << endl;
    cout << "ENDBLOCK;" << endl;
//
    return;
};
/*****************************************************************/
void NexusFileIn(vector<string> &NodeNames, string NexusFileName,
		 string &Nexus){
/*****************************************************************/
/* Read a Nexus file and extracts the translate block and the    */
/* TREE block line.                                              */
/* G. Marcou                                                     */
/*****************************************************************/
  bool fill;
  string line,stmp;
  ifstream NexusFile(NexusFileName.c_str());
  const regex rextran("TRANSLATE");
  const regex rexfill("^\\s+\\d+\\s+(.+[^,]),*$");
  const regex rextree("TREE");
  static const regex reNex(".*=\\s*(\\(.*);$");
  const string foNex("\\1");
  const string fofill("\\1");
  //  string OutNex;
  Nexus="";
  fill=false;
  while(NexusFile){
    getline(NexusFile,line);
    if(regex_search(line,rextree))
      Nexus=regex_replace(line,reNex,foNex, match_default | format_sed);
    if(fill)
      if(regex_search(line,rexfill)){
	stmp=regex_replace(line,rexfill,fofill,match_default | format_sed);
	NodeNames.push_back(stmp);
      } else
	fill=false;
    if(regex_search(line,rextran))
      fill=true;
  };
  NexusFile.close();
  return;  
};
/*****************************************************************/
void NexusTreeIn(string &Nexus, int results[][2], double distance[],
		 int &nrows){
  // nrows, int result[][2],
  //		  double linkdist[],vector<string> ListEle){
/*****************************************************************/
/* Nexus tree format output for C cluster library hirarchical    */
/* clusturing output. Output on stdout.                          */
/* G. Marcou                                                     */
/*****************************************************************/
//
  int node,leaf,mark1,cln;
  vector<int> path;
  double dist;
  char c;
  string num;
  string::iterator _Nexus;
  c=' '; num="";
  node=1; mark1=0; cln=0; leaf=0; dist=0; nrows=0;
  for(_Nexus=Nexus.begin();_Nexus!=Nexus.end();_Nexus++){
    while((int(*_Nexus)>=48)&&(int(*_Nexus)<=57)){//Is a leaf
      num+=*_Nexus;
      _Nexus++;
    };
    if(num!=""){
      leaf=str2int(num);
      _Nexus--;
      num=""; c=*_Nexus;
      results[mark1-1][cln]=leaf-1;
      nrows++;
      continue;
    };
    if((*_Nexus)==':'){//distance
      *_Nexus++;
      while(((int(*_Nexus)>=48)&&(int(*_Nexus)<=57))||(*_Nexus=='.')){
	num+=*_Nexus;
	_Nexus++;
      };
      dist=str2dbl(num);
      _Nexus--;
      num=""; c=*_Nexus;
      distance[mark1-1]=dist;
      continue;
    };
    if((c=='(')||(c==',')){
      results[mark1-1][cln]=-node;
    };
    if(*_Nexus=='('){//New node
      path.push_back(node);
      node++;
      mark1=node-1;
      cln=0;
    };
    if(*_Nexus==','){
      cln++;
    };
    if(*_Nexus==')'){
      if(cln>0)
	cln--;
      path.pop_back();
      mark1=path.back();
    };
    c=*_Nexus;
  };
  return;
};




/*****************************************************************/
void NexusTreeOut(int nrows, Node *nodes, string OutName,
		  vector<string> ListEle){
/*****************************************************************/
/* Nexus tree format output for C cluster library hirarchical    */
/* clusturing output. Output on OutName.                         */
/* G. Marcou                                                     */
/*****************************************************************/
//
  int i;//,j;
    string tree;//tree string
    vector<string> vtree;//node tree string
    bool *_vis,*_finished;//is a node already visited or finished?
    _vis=new bool [nrows-1];
    _finished=new bool [nrows-1];
    list<int> path;//trail in the tree
//
//initialization
    for(i=0;i<nrows-1;++i){
	_vis[i]=false;
	_finished[i]=false;
    };
//
    i=0;//node index
    while(i<(nrows-1)){
	if(!_vis[i]){//this node was never visited 
	    _vis[i]=true;
	    //	    j=0;//the leftmost branch
	    tree+="(";
	    if(nodes[i].left>=0){//This is a leaf
		tree+=int2str(nodes[i].left+1);
		tree+=":"+dbl2str(nodes[i].distance*100,3,4);
	    }else{//follow the branch
		if(!_finished[-nodes[i].left-1]){
		    path.push_back(i);
		    i=-nodes[i].left-1;
		}else{//if the branch was already parsed add the output
		    tree+=vtree.at(-nodes[i].left-1);
		    tree+=":"+dbl2str(nodes[i].distance*100,3,4);
		};
		continue;
	    };
	} else {//This node was already visited
	  //	    j=1;//The tree is binary. This is the rightmost branch 
	    if(!_finished[i]){//if it was not finished
		tree+=",";
		_finished[i]=true;
		if(nodes[i].right>=0){//This is a leaf
		    tree+=int2str(nodes[i].right+1);
		    tree+=":"+dbl2str(nodes[i].distance*100,3,4);
		}else{//follow the path
		    if(!_finished[-nodes[i].right-1]){
			path.push_back(i);
			i=-nodes[i].right-1;
		    }else{//if the next node was already parsed add it
			tree+=vtree.at(-nodes[i].right-1);
			tree+=":"+dbl2str(nodes[i].distance*100,3,4);
		    };
		};
		continue;
	    };
	    if(_finished[i]){//if the current node was finished
		if(!tree.empty()){//nothing to add
		    tree+=")";
		};
		if(path.empty()){//nothing to go back to
		    if(!tree.empty()){
			vtree.push_back(tree);
			tree.clear();
		    };
		    i++;//go to the next node
		}else{//go back to the parent node
		    i=path.back();
		    path.pop_back();
		};
	    };
	};
    };
    tree=vtree.back();
    tree+=";";
//Nexus format litterature
    ofstream OutTreeFile;
    OutTreeFile.open(OutName.c_str());
    OutTreeFile << "#NEXUS" << endl;
    OutTreeFile << "BEGIN TREES;" << endl;
    OutTreeFile << "[!]" << endl;
    OutTreeFile << "\t TRANSLATE" << endl;
    for(i=0;i<nrows-1;++i)
	OutTreeFile << "\t \t " << i+1 << "\t" << ListEle[i] << "," << endl;
    OutTreeFile << "\t \t " << i+1 << "\t" << ListEle[i] << endl;
    OutTreeFile << "\t \t ;" << endl;
    OutTreeFile << "\t TREE " << OutName << " = ";
    OutTreeFile << tree << endl;
    OutTreeFile << "ENDBLOCK;" << endl;
    OutTreeFile.close();
//
    return;
    };
/*****************************************************************/
void NexusTreeOut(int nrows, Node *nodes, vector<string> ListEle){
/*****************************************************************/
/* Nexus tree format output for C cluster library hirarchical    */
/* clusturing output. Output on stdout.                          */
/* G. Marcou                                                     */
/*****************************************************************/
//
  int i;//,j;
    string tree;//tree string
    vector<string> vtree;//node tree string
    bool *_vis,*_finished;//is a node already visited or finished?
    _vis=new bool [nrows-1];
    _finished=new bool [nrows-1];
    list<int> path;//trail in the tree
//
//initialization
    for(i=0;i<nrows-1;++i){
	_vis[i]=false;
	_finished[i]=false;
    };
//
    i=0;//node index
    while(i<(nrows-1)){
	if(!_vis[i]){//this node was never visited 
	    _vis[i]=true;
	    //	    j=0;//the leftmost branch
	    tree+="(";
	    if(nodes[i].left>=0){//This is a leaf
		tree+=int2str(nodes[i].left+1);
		tree+=":"+dbl2str(nodes[i].distance*100,3,4);
	    }else{//follow the branch
		if(!_finished[-nodes[i].left-1]){
		    path.push_back(i);
		    i=-nodes[i].left-1;
		}else{//if the branch was already parsed add the output
		    tree+=vtree.at(-nodes[i].left-1);
		    tree+=":"+dbl2str(nodes[i].distance*100,3,4);
		};
		continue;
	    };
	} else {//This node was already visited
	  //	    j=1;//The tree is binary. This is the rightmost branch 
	    if(!_finished[i]){//if it was not finished
		tree+=",";
		_finished[i]=true;
		if(nodes[i].right>=0){//This is a leaf
		    tree+=int2str(nodes[i].right+1);
		    tree+=":"+dbl2str(nodes[i].distance*100,3,4);
		}else{//follow the path
		    if(!_finished[-nodes[i].right-1]){
			path.push_back(i);
			i=-nodes[i].right-1;
		    }else{//if the next node was already parsed add it
			tree+=vtree.at(-nodes[i].right-1);
			tree+=":"+dbl2str(nodes[i].distance*100,3,4);
		    };
		};
		continue;
	    };
	    if(_finished[i]){//if the current node was finished
		if(!tree.empty()){//nothing to add
		    tree+=")";
		};
		if(path.empty()){//nothing to go back to
		    if(!tree.empty()){
			vtree.push_back(tree);
			tree.clear();
		    };
		    i++;//go to the next node
		}else{//go back to the parent node
		    i=path.back();
		    path.pop_back();
		};
	    };
	};
    };
    tree=vtree.back();
    tree+=";";
//Nexus format litterature
    cout << "#NEXUS" << endl;
    cout << "BEGIN TREES;" << endl;
    cout << "[!]" << endl;
    cout << "\t TRANSLATE" << endl;
    for(i=0;i<nrows-1;++i)
	cout << "\t \t " << i+1 << "\t" << ListEle[i] << "," << endl;
    cout << "\t \t " << i+1 << "\t" << ListEle[i] << endl;
    cout << "\t \t ;" << endl;
    cout << "\t TREE USER = ";
    cout << tree << endl;
    cout << "ENDBLOCK;" << endl;
//
    return;
};
/*****************************************************************/
/*****************************************************************/
void NexusTreeIn(string &Nexus, Node treenodes[],
		 int &nrows){
/*****************************************************************/
/* Nexus tree format output for C cluster library hirarchical    */
/* clusturing output. Output on stdout.                          */
/* G. Marcou                                                     */
/*****************************************************************/
//
  int node,leaf,mark1,cln;
  vector<int> path;
  double dist;
  char c;
  string num;
  string::iterator _Nexus;
  c=' '; num="";
  node=1; mark1=0; cln=0; leaf=0; dist=0; nrows=0;
  for(_Nexus=Nexus.begin();_Nexus!=Nexus.end();_Nexus++){
    while((int(*_Nexus)>=48)&&(int(*_Nexus)<=57)){//Is a leaf
      num+=*_Nexus;
      _Nexus++;
    };
    if(num!=""){
      leaf=str2int(num);
      _Nexus--;
      num=""; c=*_Nexus;
      if(cln==0)
	  treenodes[mark1-1].left=leaf-1;
      else
	  treenodes[mark1-1].right=leaf-1;
      nrows++;
      continue;
    };
    if((*_Nexus)==':'){//distance
      *_Nexus++;
      while(((int(*_Nexus)>=48)&&(int(*_Nexus)<=57))||(*_Nexus=='.')){
	num+=*_Nexus;
	_Nexus++;
      };
      dist=str2dbl(num);
      _Nexus--;
      num=""; c=*_Nexus;
      treenodes[mark1-1].distance=dist;
      continue;
    };
    if((c=='(')||(c==',')){
	if(cln==0)
	    treenodes[mark1-1].left=-node;
	else
	    treenodes[mark1-1].right=-node;
    };
    if(*_Nexus=='('){//New node
      path.push_back(node);
      node++;
      mark1=node-1;
      cln=0;
    };
    if(*_Nexus==','){
      cln++;
    };
    if(*_Nexus==')'){
      if(cln>0)
	cln--;
      path.pop_back();
      mark1=path.back();
    };
    c=*_Nexus;
  };
  return;
};
/*****************************************************************/
