/*
 *
 * icosa.c
 * Created: 20090106 Jerome Hert based on icosa.h from Sitealign-3.6
 *  
 */


#include "icosa.h"

t_point icoPointList[ICOSA_NUM_POINTS] = {
	{	0.525731,	0.000000,	0.850651	},	
	{	0.309017,	0.500000,	0.809017	},	
	{	0.000000,	0.000000,	1.000000	},	
	{	0.000000,	0.850651,	0.525731	},	
	{	-0.309017,	0.500000,	0.809017	},	
	{	-0.525731,	0.000000,	0.850651	},	
	{	0.309017,	-0.500000,	0.809017	},	
	{	-0.309017,	-0.500000,	0.809017	},	
	{	0.000000,	-0.850651,	0.525731	},	
	{	0.525731,	0.000000,	-0.850651	},	
	{	0.000000,	0.000000,	-1.000000	},	
	{	0.309017,	0.500000,	-0.809017	},	
	{	-0.525731,	0.000000,	-0.850651	},	
	{	-0.309017,	0.500000,	-0.809017	},	
	{	0.000000,	0.850651,	-0.525731	},	
	{	0.309017,	-0.500000,	-0.809017	},	
	{	0.000000,	-0.850651,	-0.525731	},	
	{	-0.309017,	-0.500000,	-0.809017	},	
	{	0.850651,	0.525731,	0.000000	},	
	{	0.809017,	0.309017,	0.500000	},	
	{	1.000000,	0.000000,	0.000000	},	
	{	0.809017,	-0.309017,	0.500000	},	
	{	0.850651,	-0.525731,	0.000000	},	
	{	0.809017,	0.309017,	-0.500000	},	
	{	0.809017,	-0.309017,	-0.500000	},	
	{	-0.850651,	-0.525731,	0.000000	},	
	{	-0.809017,	-0.309017,	0.500000	},	
	{	-1.000000,	0.000000,	0.000000	},	
	{	-0.809017,	0.309017,	0.500000	},	
	{	-0.850651,	0.525731,	0.000000	},	
	{	-0.809017,	-0.309017,	-0.500000	},	
	{	-0.809017,	0.309017,	-0.500000	},	
	{	0.500000,	0.809017,	0.309017	},	
	{	0.000000,	1.000000,	0.000000	},	
	{	0.500000,	0.809017,	-0.309017	},	
	{	-0.500000,	0.809017,	0.309017	},	
	{	-0.500000,	0.809017,	-0.309017	},	
	{	0.000000,	-1.000000,	0.000000	},	
	{	0.500000,	-0.809017,	0.309017	},	
	{	0.500000,	-0.809017,	-0.309017	},	
	{	-0.500000,	-0.809017,	0.309017	},	
	{	-0.500000,	-0.809017,	-0.309017	},	
};

t_point icoTriangleList[ICOSA_NUM_TRIANGLES] = {
	{	0,		1,		2	},
	{	1,		3,		4	},
	{	2,		4,		5	},
	{	1,		4,		2	},
	{	0,		2,		6	},
	{	2,		5,		7	},
	{	6,		7,		8	},
	{	2,		7,		6	},
	{	9,		10,		11	},
	{	10,		12,		13	},
	{	11,		13,		14	},
	{	10,		13,		11	},
	{	9,		15,		10	},
	{	15,		16,		17	},
	{	10,		17,		12	},
	{	15,		17,		10	},
	{	18,		19,		20	},
	{	19,		0,		21	},
	{	20,		21,		22	},
	{	19,		21,		20	},
	{	18,		20,		23	},
	{	20,		22,		24	},
	{	23,		24,		9	},
	{	20,		24,		23	},
	{	25,		26,		27	},
	{	26,		5,		28	},
	{	27,		28,		29	},
	{	26,		28,		27	},
	{	25,		27,		30	},
	{	27,		29,		31	},
	{	30,		31,		12	},
	{	27,		31,		30	},
	{	3,		32,		33	},
	{	32,		18,		34	},
	{	33,		34,		14	},
	{	32,		34,		33	},
	{	3,		33,		35	},
	{	33,		14,		36	},
	{	35,		36,		29	},
	{	33,		36,		35	},
	{	8,		37,		38	},
	{	37,		16,		39	},
	{	38,		39,		22	},
	{	37,		39,		38	},
	{	8,		40,		37	},
	{	40,		25,		41	},
	{	37,		41,		16	},
	{	40,		41,		37	},
	{	3,		1,		32	},
	{	1,		0,		19	},
	{	32,		19,		18	},
	{	1,		19,		32	},
	{	14,		34,		11	},
	{	34,		18,		23	},
	{	11,		23,		9	},
	{	34,		23,		11	},
	{	0,		6,		21	},
	{	6,		8,		38	},
	{	21,		38,		22	},
	{	6,		38,		21	},
	{	9,		24,		15	},
	{	24,		22,		39	},
	{	15,		39,		16	},
	{	24,		39,		15	},
	{	5,		4,		28	},
	{	4,		3,		35	},
	{	28,		35,		29	},
	{	4,		35,		28	},
	{	12,		31,		13	},
	{	31,		29,		36	},
	{	13,		36,		14	},
	{	31,		36,		13	},
	{	5,		26,		7	},
	{	26,		25,		40	},
	{	7,		40,		8	},
	{	26,		40,		7	},
	{	12,		17,		30	},
	{	17,		16,		41	},
	{	30,		41,		25	},
	{	17,		41,		30	},
};

/*
 * Test if the point is inside the Triangle i of the icosahedre
 * This is done by testing if the vector formed by the point and
 * the origin is right from the planes formed by:
 * O - A - B
 * O - B - C
 * O - C - A
 * If the vector is right from all those planes, the point
 * is inside the triangle and the function returns true.
 */

static int isInsideTriangle(t_point *point, int i) {
	t_point	triangle, p1, p2, p3;
	
	triangle	= icoTriangleList[i];
	p1			= icoPointList[ (int)triangle.x ];
	p2			= icoPointList[ (int)triangle.y ];
	p3			= icoPointList[ (int)triangle.z ];
	
	return		isRightFrom(&p1, &p2, point)
			&&	isRightFrom(&p2, &p3, point)
			&&	isRightFrom(&p3, &p1, point);
}

int mapTriangle( t_point *point) {
	int i, triangle, count = ZERO;
	for (i=ZERO;i<ICOSA_NUM_TRIANGLES;i++) {
		if (isInsideTriangle(point, i)) {
			triangle = i;
			count++;
		}
	}
	if		(count == ONE)	return triangle;
	else if	(count == ZERO)	return MINUSONE;
	return MINUSTWO;
}
