/*
 *
 * constant.h
 * Created: 20081229 Jerome Hert
 *  
 */

#ifndef __CONSTANT__
#define __CONSTANT__

/* DEBUG */
#define DEBUG_INPUT	0
#define DEBUG_MAP	0
#define DEBUG_ALIGN	0

/* General Coonstant */
#define SITEALIGN_VERSION				"4.0\0"
#define TRUE							1
#define FALSE							0
#define MINUSTWO						-2
#define MINUSONE						-1
#define ZERO							0
#define ONE								1
#define TWO								2
#define THREE							3
#define FOUR							4
#define FIVE							5
#define SIX								6
#define SEVEN							7
#define EIGHT							8
#define NINE							9
#define TEN								10
#define THIRTEEN						13
#define SIXTEEN							16
#define TWENTYONE						21
#define THIRTY							30
#define QUADNINES						9999
#define MAXCHAR							500
#define MAXLINE							5000
#define LICCHAR							40
#define PI								(4*atan2(1,1))
#define DISTANCE_MAX_SAME_ZONE			0.2

/* Constant for explore */
#define SITEALIGN_NROTATION_DEFAULT		16
#define SITEALIGN_NTRANSLATION_DEFAULT	5
#define SITEALIGN_IROTATION_DEFAULT		(8*atan2(1,1))
#define SITEALIGN_ITRANSLATION_DEFAULT	4

/* Constants for protein.h */
#define MAXATOM					50
#define MAX_RESIDUE_TYPE_LONG	4
#define MAX_ATOM_TYPE_LONG		5

/* Constant to read the PDB file */
#define	PDBAtomIndex		12
#define	PDBAtomLength		4
#define	PDBResNameIndex		17
#define	PDBResNameLength	3
#define	PDBChainIDIndex		21
#define	PDBChainIDLength	1
#define	PDBResSeqIndex		22
#define	PDBResSeqLength		4
#define	PDBXIndex			30
#define	PDBYIndex			38
#define	PDBZIndex			46
#define	PDBCoordLength		8
#define	PDBElementIndex		76
#define	PDBElementLength	2

/* Constants for icosa.h*/
#define ICOSA_NUM_POINTS	42
#define ICOSA_NUM_TRIANGLES	80

/* Constants for icosahedre triangle descriptor */
#define FP_SIZE				10
#define FP_SIZE_SCORE		8
#define FP_ALIPHATIC		0
#define FP_DONOR			1
#define FP_ACCEPTOR			2
#define FP_AROMATIC			3
#define FP_DIST				4
#define FP_SCSIZE			5
#define FP_SCOR 			6
#define FP_CHARGE			7
#define FP_RESIDUE_INDEX	8
#define FP_BITS				9 /* Used to see if the descriptor is in use or not */
#define INSIDE				1
#define OUTSIDE				2
#define PARAM_DISCRETIZATION	0.5
#define SCORE_N3_THRESHOLD	0.8

/* Constants for alignement */
#define ALIGN_NB_PASSES		3

/* Constants for file extension */
#define EXT_PDB				".pdb\0"
#define EXT_MOL2			".mol2\0"
#define	EXT_PDB_ALIGN		"_sa_aligned.pdb\0"
#define	EXT_MOL2_ALIGN		"_sa_aligned.mol2\0"
#define EXT_PDB_SIZE		5
#define EXT_MOL2_SIZE		6
#define	EXT_PDB_ALIGN_SIZE	16
#define	EXT_MOL2_ALIGN_SIZE	17

#endif
